IF OBJECT_ID('DSYNC_CLIENT') IS NULL
BEGIN
    CREATE TABLE DSYNC_CLIENT
    (
		ID INT IDENTITY(1,1) NOT NULL,
		CID INTEGER NOT NULL,
		CNAME VARCHAR(255) NOT NULL,
		CHOST VARCHAR(255) NOT NULL,
		CPORTA VARCHAR(5) NULL,
		ATIVO BIT NOT NULL,
		FLAG_NAO_CONSOLIDA BIT NOT NULL DEFAULT 0,
		FLAG_NAO_ENVIA_CARGA BIT NOT NULL DEFAULT 0,
		CONSTRAINT DSYNC_CLIENT_PKEY PRIMARY KEY (ID),
		CONSTRAINT DSYNC_CLIENT_CID_KEY UNIQUE (CID)
    )
END

GO

IF  ( NOT EXISTS ( SELECT OBJECT_ID FROM SYS.COLUMNS WHERE OBJECT_ID = OBJECT_ID('DSYNC_CLIENT') AND NAME LIKE 'ATIVO' ) )
BEGIN
    ALTER TABLE DSYNC_CLIENT ADD ATIVO BIT NOT NULL DEFAULT 0
END

GO

IF  ( NOT EXISTS ( SELECT OBJECT_ID FROM SYS.COLUMNS WHERE OBJECT_ID = OBJECT_ID('DSYNC_CLIENT') AND NAME LIKE 'CPORTA' ) )
BEGIN
    ALTER TABLE DSYNC_CLIENT ADD CPORTA VARCHAR(5) NULL
END

IF  ( NOT EXISTS ( SELECT OBJECT_ID FROM SYS.COLUMNS WHERE OBJECT_ID = OBJECT_ID('DSYNC_CLIENT') AND NAME LIKE 'CVERSION' ) )
BEGIN
    ALTER TABLE DSYNC_CLIENT ADD CVERSION VARCHAR(255)
END

GO

BEGIN TRY
	IF OBJECT_ID('PK_DSYNC_CLIENT') IS NULL
	BEGIN
		ALTER TABLE DSYNC_CLIENT ADD CONSTRAINT PK_DSYNC_CLIENT PRIMARY KEY(ID)
	END
END TRY
BEGIN CATCH
END CATCH

GO

IF COL_LENGTH('DSYNC_CLIENT','FLAG_NAO_CONSOLIDA') IS NULL
BEGIN
	ALTER TABLE DSYNC_CLIENT ADD FLAG_NAO_CONSOLIDA BIT NOT NULL DEFAULT 0 
END

GO

IF COL_LENGTH('DSYNC_CLIENT','FLAG_NAO_ENVIA_CARGA') IS NULL
BEGIN
	ALTER TABLE DSYNC_CLIENT ADD FLAG_NAO_ENVIA_CARGA BIT NOT NULL DEFAULT 0 
END